	function H = ALLPASS_FREQ_Z(P, wT)
 
	% 	Computes the frequency response of an allpass filter.
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramki, 2017-12-04
	% 	Modified by: 	TS 2017-12-04, LW 2018-08-24
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi
	
	H = ones(1,length(wT));
	expiwT = exp(-j*wT);
	for n = 1:length(P)
		H = H.*(expiwT-P(n))./(1-P(n)*expiwT);
	end
	
